/*****************************************************************************
*  LPC15xx SCT PLL program for LPCXpresso board
*
*  1. Use SCT1 timer to generate a 100 msec clock output @ SCT1_OUT0
*  2. SCT1_OUT0 is linked to P0_3 (green LED toggles every 100 msec)
*  3. Input clock to SCT1 is the SCT PLL running at 72 MHz
*****************************************************************************/
#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
extern void SCT1_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);			                   				                  // enable the SCT1 clock

	Chip_SCT_Config(LPC_SCT1, SCT_CONFIG_32BIT_COUNTER 		  |			            // unified timers,
                            SCT_CONFIG_AUTOLIMIT_L   		  |			            // auto limit
                            SCT_CONFIG_CLKMODE_INEDGECLK	|			            // Input clock edge selected in CLKSEL field
                            (0xF << 3)    				        );  		          // falling edge of input 7 (SCT PLL)



	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_0, (72000000/10) -1);				            // match 0 @ 10 Hz = 100 msec
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, (72000000/10) -1);


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_ALL_STATES);	 	// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0, SCT_COMBMODE_MATCH); 	// match 0 only condition

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_0 );  			// event 0 will set SCT0_OUT0
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_0); 			// event 0 will clear SCT0_OUT0

    Chip_SCT_SetConflictResolution(LPC_SCT1, 0, 3);		   				// toggle OUT0 on conflict


    Chip_SCT_ClearControl(LPC_SCT1,SCT_CTRL_HALT_L);					// unhalt it by clearing bit 2 of the CTRL register
}


int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();


	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_SWM);			// enable SWM clock


	Chip_SWM_MovablePortPinAssign(SWM_SCT1_OUT0_O , 0, 3);	//SCT1_OUT0 = P0.3 = green LED

	Chip_SYSCTL_PowerUp(SYSCTL_POWERDOWN_SCTPLL_PD);		// power-up SCT PLL
	Chip_Clock_SetSCTPLLSource(SYSCTL_PLLCLKSRC_IRC);  		// select SCT PLL input = IRC

	Chip_Clock_SetupSCTPLL(11, 0);							//MSEL = 11 changed to get @100msec clk cycle
															// MSEL = 12 -> M = MSEL + 1 = 13
															// PSEL = 0 -> P = 1

	 while (Chip_Clock_IsSCTPLLLocked());      				// wait until SCT PLL locked

    SCT1_Init();                                          	// Initialize SCT1


    while (1)                                              		// loop forever
    {
    	__WFI();
    }
}
